/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;

class FourierFrame
extends Frame
implements ComponentListener,
ActionListener,
AdjustmentListener,
MouseMotionListener,
MouseListener,
ItemListener {
    PlayThread playThread;
    Dimension winSize;
    Image dbimage;
    Random random;
    public static final int sampleCount = 1024;
    public static final int halfSampleCount = 512;
    public static final double halfSampleCountFloat = 512.0;
    final int rate = 22050;
    final int playSampleCount = 16384;
    Fourier applet;
    NumberFormat showFormat;
    public boolean useFrame;
    Container main;
    Button sineButton;
    Button cosineButton;
    Button rectButton;
    Button fullRectButton;
    Button triangleButton;
    Button sawtoothButton;
    Button squareButton;
    Button noiseButton;
    Button blankButton;
    Button phaseButton;
    Button clipButton;
    Button resampleButton;
    Button quantizeButton;
    Button highPassButton;
    Checkbox magPhaseCheck;
    Checkbox soundCheck;
    Checkbox logCheck;
    Scrollbar termBar;
    Scrollbar freqBar;
    double[] magcoef;
    double[] phasecoef;
    boolean[] mutes;
    boolean[] solos;
    boolean hasSolo;
    static final double pi = Math.PI;
    static final double step = 0.006135923151542565;
    double[] func;
    int maxTerms = 160;
    int selectedCoef;
    static final int SEL_NONE = 0;
    static final int SEL_FUNC = 1;
    static final int SEL_MAG = 2;
    static final int SEL_PHASE = 3;
    static final int SEL_MUTES = 4;
    static final int SEL_SOLOS = 5;
    int selection;
    int dragX;
    int dragY;
    int quantizeCount;
    int resampleCount;
    boolean dragging;
    boolean freqAdjusted;
    View viewFunc;
    View viewMag;
    View viewPhase;
    View viewMutes;
    View viewSolos;
    FFT fft;
    FourierCanvas cv;
    boolean java2;
    Hashtable showTable;
    boolean shown = false;
    double[] origFunc;
    int dfreq0;
    static /* synthetic */ Class class$java$lang$Class;

    public String getAppletInfo() {
        return "Fourier Series by Paul Falstad";
    }

    FourierFrame(Fourier fourier) {
        super("Fourier Series Applet v1.6d");
        this.applet = fourier;
        this.useFrame = true;
    }

    int getrand(int n) {
        int n2 = this.random.nextInt();
        if (n2 < 0) {
            n2 = -n2;
        }
        return n2 % n;
    }

    boolean mustShow(String string) {
        return this.showTable == null || this.showTable.containsKey(string);
    }

    Button doButton(String string) {
        Button button = new Button(string);
        if (this.mustShow(string)) {
            this.main.add(button);
        }
        button.addActionListener(this);
        return button;
    }

    Checkbox doCheckbox(String string) {
        Checkbox checkbox = new Checkbox(string);
        if (this.mustShow(string)) {
            this.main.add(checkbox);
        }
        try {
            String string2 = this.applet.getParameter(string);
            if (string2 != null && string2.equalsIgnoreCase("true")) {
                checkbox.setState(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        checkbox.addItemListener(this);
        return checkbox;
    }

    public void init() {
        Object object;
        Object object2;
        String string = System.getProperty("java.class.version");
        double d = new Double(string);
        if (d >= 48.0) {
            this.java2 = true;
        }
        String string2 = "";
        try {
            object2 = this.applet.getParameter("useFrame");
            if (object2 != null && ((String)object2).equalsIgnoreCase("false")) {
                this.useFrame = false;
            }
            if ((object = this.applet.getParameter("show")) != null) {
                this.showTable = new Hashtable(10);
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    this.showTable.put(string3, "");
                }
                this.showTable.put("Sound", "");
            }
            string2 = this.applet.getParameter("state");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.main = this.useFrame ? this : this.applet;
        this.selectedCoef = -1;
        this.magcoef = new double[this.maxTerms];
        this.phasecoef = new double[this.maxTerms];
        this.mutes = new boolean[this.maxTerms];
        this.solos = new boolean[this.maxTerms];
        this.func = new double[1025];
        this.random = new Random();
        this.fft = new FFT(1024);
        this.main.setLayout(new FourierLayout());
        this.cv = new FourierCanvas(this);
        this.cv.addComponentListener(this);
        this.cv.addMouseMotionListener(this);
        this.cv.addMouseListener(this);
        this.main.add(this.cv);
        this.sineButton = this.doButton("Sine");
        this.cosineButton = this.doButton("Cosine");
        this.triangleButton = this.doButton("Triangle");
        this.sawtoothButton = this.doButton("Sawtooth");
        this.squareButton = this.doButton("Square");
        this.noiseButton = this.doButton("Noise");
        this.phaseButton = this.doButton("Phase Shift");
        this.clipButton = this.doButton("Clip");
        this.resampleButton = this.doButton("Resample");
        this.quantizeButton = this.doButton("Quantize");
        this.rectButton = this.doButton("Rectify");
        this.fullRectButton = this.doButton("Full Rectify");
        this.highPassButton = this.doButton("High-Pass Filter");
        this.blankButton = this.doButton("Clear");
        this.soundCheck = this.doCheckbox("Sound");
        if (!this.java2) {
            this.remove(this.soundCheck);
        }
        this.magPhaseCheck = this.doCheckbox("Mag/Phase View");
        this.logCheck = this.doCheckbox("Log View");
        this.logCheck.disable();
        if (this.mustShow("Terms")) {
            this.main.add(new Label("Number of Terms", 1));
        }
        this.termBar = new Scrollbar(0, 50, 1, 1, this.maxTerms);
        this.termBar.addAdjustmentListener(this);
        if (this.mustShow("Terms")) {
            this.main.add(this.termBar);
        }
        if (this.java2) {
            this.main.add(new Label("Playing Frequency", 1));
        }
        this.freqBar = new Scrollbar(0, 251, 1, -100, 500);
        this.freqBar.addAdjustmentListener(this);
        if (this.java2) {
            this.main.add(this.freqBar);
        }
        this.main.add(new Label("http://www.falstad.com"));
        this.cv.setBackground(Color.black);
        this.cv.setForeground(Color.lightGray);
        this.showFormat = DecimalFormat.getInstance();
        this.showFormat.setMaximumFractionDigits(5);
        if (string2.equalsIgnoreCase("square")) {
            this.doSquare();
        } else if (string2.equalsIgnoreCase("sine")) {
            this.doSine();
        } else if (string2.equalsIgnoreCase("triangle")) {
            this.doTriangle();
        } else if (string2.equalsIgnoreCase("noise")) {
            this.doNoise();
        } else if (string2.equalsIgnoreCase("quant")) {
            this.doSine();
            this.doQuantize();
        } else if (string2.equalsIgnoreCase("resample")) {
            this.doSine();
            this.doResample();
        } else if (string2.equalsIgnoreCase("clip")) {
            this.doSine();
            this.doClip();
        } else if (string2.equalsIgnoreCase("rect")) {
            this.doSine();
            this.doRect();
        } else if (string2.equalsIgnoreCase("fullrect")) {
            this.doSine();
            this.doFullRect();
        } else if (string2.equalsIgnoreCase("fullsaw")) {
            this.doSawtooth();
            this.doFullRect();
        } else if (string2.equalsIgnoreCase("beats")) {
            this.doBeats();
        } else if (string2.equalsIgnoreCase("loudsoft")) {
            this.doLoudSoft();
        } else {
            this.doSawtooth();
        }
        if (this.useFrame) {
            this.resize(800, 640);
            this.handleResize();
            object2 = this.getSize();
            object = this.getToolkit().getScreenSize();
            this.setLocation((((Dimension)object).width - ((Dimension)object2).width) / 2, (((Dimension)object).height - ((Dimension)object2).height) / 2);
            this.show();
        } else {
            this.hide();
            this.handleResize();
            this.applet.validate();
        }
        this.main.requestFocus();
    }

    void handleResize() {
        Dimension dimension = this.winSize = this.cv.getSize();
        if (this.winSize.width == 0) {
            return;
        }
        this.dbimage = this.cv.createImage(dimension.width, dimension.height);
        int n = 20;
        int n2 = (dimension.height - n * 2) / 3;
        this.viewFunc = new View(0, 0, dimension.width, n2);
        int n3 = n2 + n * 2;
        this.viewMag = new View(0, n3, dimension.width, n2);
        if (this.magPhaseCheck.getState()) {
            this.viewMag.ymult *= 1.6;
            this.viewMag.midy += (int)this.viewMag.ymult / 2;
            this.logCheck.enable();
        } else {
            this.logCheck.disable();
            this.logCheck.setState(false);
        }
        this.viewPhase = new View(0, n3 += n2, dimension.width, n2);
        int n4 = this.viewPhase.midy + (int)this.viewPhase.ymult + 10;
        int n5 = (dimension.height - n4) / 2;
        this.viewMutes = new View(0, n4, dimension.width, n5);
        this.viewSolos = new View(0, n4 + n5, dimension.width, n5);
    }

    public void triggerShow() {
        if (!this.shown) {
            this.show();
        }
        this.shown = true;
    }

    void doBeats() {
        for (int i = 0; i != 1024; ++i) {
            double d = (double)(i - 512) * 0.006135923151542565;
            this.func[i] = 0.5 * (Math.cos(d * 20.0) + Math.cos(d * 21.0));
        }
        this.func[1024] = this.func[0];
        this.transform();
        this.freqBar.setValue(-100);
    }

    void doLoudSoft() {
        for (int i = 0; i != 1024; ++i) {
            double d = (double)(i - 512) * 0.006135923151542565;
            this.func[i] = Math.cos(d) + 0.05 * Math.cos(d * 10.0);
        }
        this.func[1024] = this.func[0];
        this.transform();
    }

    void doSawtooth() {
        for (int i = 0; i != 1024; ++i) {
            this.func[i] = (double)(i - 512) / 512.0;
        }
        this.func[1024] = this.func[0];
        this.transform();
    }

    void doTriangle() {
        for (int i = 0; i != 512; ++i) {
            this.func[i] = (double)(i * 2 - 512) / 512.0;
            this.func[i + 512] = (double)((512 - i) * 2 - 512) / 512.0;
        }
        this.func[1024] = this.func[0];
        this.transform();
    }

    void doSine() {
        for (int i = 0; i != 1024; ++i) {
            this.func[i] = Math.sin((double)(i - 512) * 0.006135923151542565);
        }
        this.func[1024] = this.func[0];
        this.transform();
    }

    void doCosine() {
        for (int i = 0; i != 1024; ++i) {
            this.func[i] = Math.cos((double)(i - 512) * 0.006135923151542565);
        }
        this.func[1024] = this.func[0];
        this.transform();
    }

    void doRect() {
        for (int i = 0; i != 1024; ++i) {
            if (!(this.func[i] < 0.0)) continue;
            this.func[i] = 0.0;
        }
        this.func[1024] = this.func[0];
        this.transform();
    }

    void doFullRect() {
        for (int i = 0; i != 1024; ++i) {
            if (!(this.func[i] < 0.0)) continue;
            this.func[i] = -this.func[i];
        }
        this.func[1024] = this.func[0];
        this.transform();
    }

    void doHighPass() {
        int n = this.termBar.getValue();
        for (int i = 0; i != n; ++i) {
            if (this.magcoef[i] == 0.0) continue;
            this.magcoef[i] = 0.0;
            break;
        }
        this.doSetFunc();
    }

    void doSquare() {
        for (int i = 0; i != 512; ++i) {
            this.func[i] = -1.0;
            this.func[i + 512] = 1.0;
        }
        this.func[1024] = this.func[0];
        this.transform();
    }

    void doNoise() {
        int n = 3;
        for (int i = 0; i != 1024 / n; ++i) {
            double d = Math.random() * 2.0 - 1.0;
            for (int j = 0; j != n; ++j) {
                this.func[i * n + j] = d;
            }
        }
        this.func[1024] = this.func[0];
        this.transform();
    }

    void doPhaseShift() {
        int n;
        int n2 = 51;
        double[] dArray = new double[n2];
        for (n = 0; n != n2; ++n) {
            dArray[n] = this.func[n];
        }
        for (n = 0; n != 1024 - n2; ++n) {
            this.func[n] = this.func[n + n2];
        }
        for (n = 0; n != n2; ++n) {
            this.func[1024 - n2 + n] = dArray[n];
        }
        this.func[1024] = this.func[0];
        this.transform();
    }

    void doBlank() {
        int n;
        for (n = 0; n <= 1024; ++n) {
            this.func[n] = 0.0;
        }
        for (n = 0; n != this.termBar.getValue(); ++n) {
            this.solos[n] = false;
            this.mutes[n] = false;
        }
        this.transform();
    }

    void doSetFunc() {
        int n;
        double[] dArray = new double[2048];
        int n2 = this.termBar.getValue();
        for (n = 0; n != n2; ++n) {
            int n3 = (n & 1) == 1 ? -1 : 1;
            dArray[n * 2] = (double)n3 * this.magcoef[n] * Math.cos(this.phasecoef[n]);
            dArray[n * 2 + 1] = (double)(-n3) * this.magcoef[n] * Math.sin(this.phasecoef[n]);
        }
        this.fft.transform(dArray, true);
        for (n = 0; n != 1024; ++n) {
            this.func[n] = dArray[n * 2];
        }
        this.func[1024] = this.func[0];
        this.updateSound();
    }

    void updateSound() {
        if (this.playThread != null) {
            this.playThread.soundChanged();
        }
    }

    void doClip() {
        double d = 1.2;
        for (int i = 0; i != 1024; ++i) {
            int n = i;
            this.func[n] = this.func[n] * d;
            if (this.func[i] > 1.0) {
                this.func[i] = 1.0;
            }
            if (!(this.func[i] < -1.0)) continue;
            this.func[i] = -1.0;
        }
        this.func[1024] = this.func[0];
        this.transform();
    }

    void doResample() {
        if (this.resampleCount == 0) {
            this.resampleCount = 32;
        }
        if (this.resampleCount == 1024) {
            return;
        }
        for (int i = 0; i != 1024; i += this.resampleCount) {
            for (int j = 1; j != this.resampleCount; ++j) {
                this.func[i + j] = this.func[i];
            }
        }
        this.func[1024] = this.func[0];
        this.transform();
        this.resampleCount *= 2;
    }

    void doQuantize() {
        if (this.quantizeCount == 0) {
            this.quantizeCount = 8;
            this.origFunc = new double[1024];
            System.arraycopy(this.func, 0, this.origFunc, 0, 1024);
        }
        for (int i = 0; i != 1024; ++i) {
            this.func[i] = (double)Math.round(this.origFunc[i] * (double)this.quantizeCount) / (double)this.quantizeCount;
        }
        this.func[1024] = this.func[0];
        this.transform();
        this.quantizeCount /= 2;
    }

    double getFreq() {
        double d = 27.5 * Math.exp((double)this.freqBar.getValue() * 0.004158883084 * 2.0);
        this.dfreq0 = (int)(d * 16384.0 / 22050.0) * 2;
        return (double)(22050 * this.dfreq0) / 32768.0;
    }

    void transform() {
        double[] dArray = new double[2048];
        for (int i = 0; i != 1024; ++i) {
            dArray[i * 2] = this.func[i];
        }
        this.fft.transform(dArray, false);
        double d = 1.0E-5;
        double d2 = 0.001953125;
        for (int i = 0; i != this.maxTerms; ++i) {
            double d3 = dArray[i * 2] * d2;
            double d4 = -dArray[i * 2 + 1] * d2;
            if ((i & 1) == 1) {
                d3 = -d3;
            } else {
                d4 = -d4;
            }
            if (d3 < d && d3 > -d) {
                d3 = 0.0;
            }
            if (d4 < d && d4 > -d) {
                d4 = 0.0;
            }
            if (i == 0) {
                this.magcoef[0] = d3 / 2.0;
                this.phasecoef[0] = 0.0;
                continue;
            }
            this.magcoef[i] = Math.sqrt(d3 * d3 + d4 * d4);
            this.phasecoef[i] = Math.atan2(-d4, d3);
        }
        this.updateSound();
    }

    void centerString(Graphics graphics, String string, int n) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.drawString(string, (this.winSize.width - fontMetrics.stringWidth(string)) / 2, n);
    }

    public void paint(Graphics graphics) {
        this.cv.repaint();
    }

    public void updateFourier(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (this.winSize == null || this.winSize.width == 0 || this.dbimage == null) {
            return;
        }
        Graphics graphics2 = this.dbimage.getGraphics();
        Color color = new Color(76, 76, 76);
        Color color2 = new Color(127, 127, 127);
        graphics2.setColor(this.cv.getBackground());
        graphics2.fillRect(0, 0, this.winSize.width, this.winSize.height);
        graphics2.setColor(this.cv.getForeground());
        int n7 = -1;
        int n8 = -1;
        int n9 = this.viewFunc.midy;
        int n10 = this.viewFunc.periodWidth;
        double d = this.viewFunc.ymult;
        for (n6 = -1; n6 <= 1; ++n6) {
            graphics2.setColor(n6 == 0 ? color2 : color);
            graphics2.drawLine(0, n9 + n6 * (int)d, this.winSize.width, n9 + n6 * (int)d);
        }
        for (n6 = 2; n6 <= 4; ++n6) {
            graphics2.setColor(n6 == 3 ? color2 : color);
            graphics2.drawLine(n10 * n6 / 2, n9 - (int)d, n10 * n6 / 2, n9 + (int)d);
        }
        graphics2.setColor(Color.white);
        if (!this.dragging || this.selection == 1) {
            for (n6 = 0; n6 != 1025; ++n6) {
                n5 = n10 * n6 / 1024;
                n4 = n9 - (int)(d * this.func[n6]);
                if (n7 != -1) {
                    graphics2.drawLine(n7, n8, n5, n4);
                    graphics2.drawLine(n7 + n10, n8, n5 + n10, n4);
                    graphics2.drawLine(n7 + n10 * 2, n8, n5 + n10 * 2, n4);
                }
                n7 = n5;
                n8 = n4;
            }
        }
        n5 = this.termBar.getValue();
        if (!this.dragging || this.selection != 1) {
            graphics2.setColor(Color.red);
            n7 = -1;
            for (n6 = 0; n6 != 1025; ++n6) {
                n4 = n10 * n6 / 1024;
                double d2 = 0.0;
                for (int i = 0; i != n5; ++i) {
                    d2 += this.magcoef[i] * Math.cos(0.006135923151542565 * (double)(n6 - 512) * (double)i + this.phasecoef[i]);
                }
                int n11 = n9 - (int)(d * d2);
                if (n7 != -1) {
                    graphics2.drawLine(n7, n8, n4, n11);
                    graphics2.drawLine(n7 + n10, n8, n4 + n10, n11);
                    graphics2.drawLine(n7 + n10 * 2, n8, n4 + n10 * 2, n11);
                }
                n7 = n4;
                n8 = n11;
            }
        }
        n4 = this.viewFunc.height + 10;
        if (this.selectedCoef != -1) {
            graphics2.setColor(Color.yellow);
            n7 = -1;
            double d3 = this.phasecoef[this.selectedCoef];
            double d4 = (double)(this.selectedCoef * 2) * Math.PI / (double)n10;
            n3 = n10 / 2;
            double d5 = this.magcoef[this.selectedCoef];
            if (!this.magPhaseCheck.getState()) {
                if (this.selection == 2) {
                    d5 *= -Math.sin(d3);
                    d3 = -1.5707963267948966;
                } else {
                    d5 *= Math.cos(d3);
                    d3 = 0.0;
                }
            }
            d *= d5;
            if (!this.dragging) {
                for (n6 = 0; n6 != 1025; ++n6) {
                    n2 = n10 * n6 / 1024;
                    double d6 = Math.cos(0.006135923151542565 * (double)(n6 - 512) * (double)this.selectedCoef + d3);
                    int n12 = n9 - (int)(d * d6);
                    if (n7 != -1) {
                        graphics2.drawLine(n7, n8, n2, n12);
                        graphics2.drawLine(n7 + n10, n8, n2 + n10, n12);
                        graphics2.drawLine(n7 + n10 * 2, n8, n2 + n10 * 2, n12);
                    }
                    n7 = n2;
                    n8 = n12;
                }
            }
            if (this.selectedCoef > 0 && this.java2) {
                int n13 = (int)(this.getFreq() * (double)this.selectedCoef);
                this.centerString(graphics2, n13 + (n13 > 11025 ? " Hz (filtered)" : " Hz"), n4);
            }
            if (this.selectedCoef != -1) {
                String string;
                if (this.selectedCoef == 0) {
                    string = this.showFormat.format(d5) + "";
                } else {
                    String string2 = "cos";
                    if (!this.magPhaseCheck.getState() && this.selection == 2) {
                        string2 = "sin";
                    }
                    string = this.selectedCoef == 1 ? this.showFormat.format(d5) + " " + string2 + "(x" : this.showFormat.format(d5) + " " + string2 + "(" + this.selectedCoef + "x";
                    if (!this.magPhaseCheck.getState() || d3 == 0.0) {
                        string = string + ")";
                    } else {
                        string = string + (d3 < 0.0 ? " - " : " + ");
                        string = string + this.showFormat.format(Math.abs(d3)) + ")";
                    }
                    if (this.logCheck.getState()) {
                        this.showFormat.setMaximumFractionDigits(2);
                        string = string + "   (" + this.showFormat.format(20.0 * Math.log(d5) / Math.log(10.0)) + " dB)";
                        this.showFormat.setMaximumFractionDigits(5);
                    }
                }
                this.centerString(graphics2, string, n4 + 15);
            }
        }
        if (this.selectedCoef == -1 && this.freqAdjusted && this.java2) {
            int n14 = (int)this.getFreq();
            graphics2.setColor(Color.yellow);
            this.centerString(graphics2, n14 + " Hz", n4);
        }
        this.freqAdjusted = false;
        int n15 = this.getTermWidth();
        d = this.viewMag.ymult;
        n9 = this.viewMag.midy;
        graphics2.setColor(Color.white);
        if (this.magPhaseCheck.getState()) {
            this.centerString(graphics2, "Magnitudes", this.viewMag.labely);
            this.centerString(graphics2, "Phases", this.viewPhase.labely);
            graphics2.setColor(color2);
            graphics2.drawLine(0, n9, this.winSize.width, n9);
            graphics2.setColor(color);
            graphics2.drawLine(0, n9 - (int)d, this.winSize.width, n9 - (int)d);
            n = n15 - 3;
            for (n6 = 0; n6 != n5; ++n6) {
                n2 = n15 * n6 + n15 / 2;
                int n16 = n9 - (int)(this.showMag(n6) * d);
                graphics2.setColor(n6 == this.selectedCoef ? Color.yellow : Color.white);
                graphics2.drawLine(n2, n9, n2, n16);
                graphics2.fillOval(n2 - n / 2, n16 - n / 2, n, n);
            }
            d = this.viewPhase.ymult;
            n9 = this.viewPhase.midy;
            for (n6 = -2; n6 <= 2; ++n6) {
                graphics2.setColor(n6 == 0 ? color2 : color);
                graphics2.drawLine(0, n9 + n6 * (int)d / 2, this.winSize.width, n9 + n6 * (int)d / 2);
            }
            d /= Math.PI;
            for (n6 = 0; n6 != n5; ++n6) {
                n2 = n15 * n6 + n15 / 2;
                int n17 = n9 - (int)(this.phasecoef[n6] * d);
                graphics2.setColor(n6 == this.selectedCoef ? Color.yellow : Color.white);
                graphics2.drawLine(n2, n9, n2, n17);
                graphics2.fillOval(n2 - n / 2, n17 - n / 2, n, n);
            }
        } else {
            this.centerString(graphics2, "Sines", this.viewMag.labely);
            this.centerString(graphics2, "Cosines", this.viewPhase.labely);
            graphics2.setColor(color2);
            graphics2.drawLine(0, n9, this.winSize.width, n9);
            graphics2.setColor(color);
            graphics2.drawLine(0, n9 - (int)d, this.winSize.width, n9 - (int)d);
            graphics2.drawLine(0, n9 + (int)d, this.winSize.width, n9 + (int)d);
            n = n15 - 3;
            for (n6 = 1; n6 != n5; ++n6) {
                n2 = n15 * n6 + n15 / 2;
                int n18 = n9 + (int)(this.magcoef[n6] * Math.sin(this.phasecoef[n6]) * d);
                graphics2.setColor(n6 == this.selectedCoef ? Color.yellow : Color.white);
                graphics2.drawLine(n2, n9, n2, n18);
                graphics2.fillOval(n2 - n / 2, n18 - n / 2, n, n);
            }
            d = this.viewPhase.ymult;
            n9 = this.viewPhase.midy;
            for (n6 = -2; n6 <= 2; n6 += 2) {
                graphics2.setColor(n6 == 0 ? color2 : color);
                graphics2.drawLine(0, n9 + n6 * (int)d / 2, this.winSize.width, n9 + n6 * (int)d / 2);
            }
            for (n6 = 0; n6 != n5; ++n6) {
                n2 = n15 * n6 + n15 / 2;
                int n19 = n9 - (int)(this.magcoef[n6] * Math.cos(this.phasecoef[n6]) * d);
                graphics2.setColor(n6 == this.selectedCoef ? Color.yellow : Color.white);
                graphics2.drawLine(n2, n9, n2, n19);
                graphics2.fillOval(n2 - n / 2, n19 - n / 2, n, n);
            }
        }
        double d7 = this.getFreq();
        if (this.viewMutes.height > 8) {
            Font font = new Font("SansSerif", 0, this.viewMutes.height);
            graphics2.setFont(font);
            FontMetrics fontMetrics = graphics2.getFontMetrics();
            for (n6 = 1; n6 != n5 && !(d7 * (double)n6 > 11025.0); ++n6) {
                n3 = n15 * n6 + n15 / 2;
                int n20 = this.viewMutes.y + fontMetrics.getAscent();
                graphics2.setColor(n6 == this.selectedCoef ? Color.yellow : Color.white);
                if (this.hasSolo && !this.solos[n6]) {
                    graphics2.setColor(Color.gray);
                }
                String string = "-";
                if (this.mutes[n6]) {
                    string = "M";
                }
                int n21 = fontMetrics.stringWidth(string);
                graphics2.drawString(string, n3 - n21 / 2, n20);
                n20 = this.viewSolos.y + fontMetrics.getAscent();
                string = "-";
                if (this.solos[n6]) {
                    string = "S";
                }
                n21 = fontMetrics.stringWidth(string);
                graphics2.drawString(string, n3 - n21 / 2, n20);
            }
        }
        graphics.drawImage(this.dbimage, 0, 0, this);
    }

    double showMag(int n) {
        double d = this.magcoef[n];
        if (!this.logCheck.getState() || n == 0) {
            return d;
        }
        return (d = Math.log(d) / 6.0 + 1.0) < 0.0 ? 0.0 : d;
    }

    double getMagValue(double d) {
        if (!this.logCheck.getState()) {
            return d;
        }
        if (d == 0.0) {
            return 0.0;
        }
        return Math.exp(6.0 * (d - 1.0));
    }

    int getTermWidth() {
        int n;
        int n2 = this.termBar.getValue();
        int n3 = this.winSize.width / n2;
        if (n3 > (n = this.winSize.width / 30)) {
            n3 = n;
        }
        if (n3 > 12) {
            n3 = 12;
        }
        return n3 &= 0xFFFFFFFE;
    }

    void edit(MouseEvent mouseEvent) {
        if (this.selection == 0) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        switch (this.selection) {
            case 2: {
                this.editMag(n, n2);
                break;
            }
            case 1: {
                this.editFunc(n, n2);
                break;
            }
            case 3: {
                this.editPhase(n, n2);
                break;
            }
            case 4: {
                this.editMutes(mouseEvent, n, n2);
                break;
            }
            case 5: {
                this.editSolos(mouseEvent, n, n2);
            }
        }
        this.resampleCount = 0;
        this.quantizeCount = 0;
    }

    void editMag(int n, int n2) {
        if (this.selectedCoef == -1) {
            return;
        }
        double d = this.viewMag.ymult;
        double d2 = this.viewMag.midy;
        double d3 = -((double)n2 - d2) / d;
        if (this.magPhaseCheck.getState()) {
            if (this.selectedCoef > 0) {
                if (d3 < 0.0) {
                    d3 = 0.0;
                }
                d3 = this.getMagValue(d3);
            } else if (d3 < -1.0) {
                d3 = -1.0;
            }
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            if (this.magcoef[this.selectedCoef] == d3) {
                return;
            }
            this.magcoef[this.selectedCoef] = d3;
        } else {
            int n3 = this.selectedCoef;
            if (n3 == 0) {
                return;
            }
            double d4 = this.magcoef[n3] * Math.cos(this.phasecoef[n3]);
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            if (d3 < -1.0) {
                d3 = -1.0;
            }
            double d5 = d3;
            this.magcoef[n3] = Math.sqrt(d5 * d5 + d4 * d4);
            this.phasecoef[n3] = Math.atan2(-d5, d4);
        }
        this.updateSound();
        this.cv.repaint();
    }

    void editFunc(int n, int n2) {
        if (this.dragX == n) {
            this.editFuncPoint(n, n2);
            this.dragY = n2;
        } else {
            int n3 = n < this.dragX ? n : this.dragX;
            int n4 = n < this.dragX ? n2 : this.dragY;
            int n5 = n > this.dragX ? n : this.dragX;
            int n6 = n > this.dragX ? n2 : this.dragY;
            this.dragX = n;
            this.dragY = n2;
            for (n = n3; n <= n5; ++n) {
                n2 = n4 + (n6 - n4) * (n - n3) / (n5 - n3);
                this.editFuncPoint(n, n2);
            }
        }
    }

    void editFuncPoint(int n, int n2) {
        int n3 = this.viewFunc.midy;
        int n4 = this.viewFunc.periodWidth;
        double d = this.viewFunc.ymult;
        int n5 = n % n4 * 1024 / n4;
        int n6 = (n % n4 + 1) * 1024 / n4 - 1;
        double d2 = (double)(n3 - n2) / d;
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        if (d2 < -1.0) {
            d2 = -1.0;
        }
        while (n5 <= n6) {
            this.func[n5] = d2;
            ++n5;
        }
        this.func[1024] = this.func[0];
        this.cv.repaint();
    }

    void editPhase(int n, int n2) {
        if (this.selectedCoef == -1) {
            return;
        }
        double d = this.viewPhase.ymult;
        double d2 = this.viewPhase.midy;
        double d3 = -((double)n2 - d2) / d;
        if (this.magPhaseCheck.getState()) {
            if ((d3 *= Math.PI) < -Math.PI) {
                d3 = -Math.PI;
            }
            if (d3 > Math.PI) {
                d3 = Math.PI;
            }
            if (this.phasecoef[this.selectedCoef] == d3) {
                return;
            }
            this.phasecoef[this.selectedCoef] = d3;
        } else {
            int n3 = this.selectedCoef;
            double d4 = -this.magcoef[n3] * Math.sin(this.phasecoef[n3]);
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            if (d3 < -1.0) {
                d3 = -1.0;
            }
            double d5 = d3;
            this.magcoef[n3] = Math.sqrt(d4 * d4 + d5 * d5);
            this.phasecoef[n3] = Math.atan2(-d4, d5);
            this.updateSound();
        }
        this.cv.repaint();
    }

    void editMutes(MouseEvent mouseEvent, int n, int n2) {
        if (mouseEvent.getID() != 501) {
            return;
        }
        if (this.selectedCoef == -1) {
            return;
        }
        this.mutes[this.selectedCoef] = !this.mutes[this.selectedCoef];
        this.cv.repaint();
    }

    void editSolos(MouseEvent mouseEvent, int n, int n2) {
        if (mouseEvent.getID() != 501) {
            return;
        }
        if (this.selectedCoef == -1) {
            return;
        }
        this.solos[this.selectedCoef] = !this.solos[this.selectedCoef];
        int n3 = this.termBar.getValue();
        this.hasSolo = false;
        for (int i = 0; i != n3; ++i) {
            if (!this.solos[i]) continue;
            this.hasSolo = true;
            break;
        }
        this.cv.repaint();
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.cv.repaint();
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.handleResize();
        this.cv.repaint(100L);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.pressButton(actionEvent.getSource());
    }

    void pressButton(Object object) {
        if (object == this.triangleButton) {
            this.doTriangle();
            this.cv.repaint();
        }
        if (object == this.sineButton) {
            this.doSine();
            this.cv.repaint();
        }
        if (object == this.cosineButton) {
            this.doCosine();
            this.cv.repaint();
        }
        if (object == this.rectButton) {
            this.doRect();
            this.cv.repaint();
        }
        if (object == this.fullRectButton) {
            this.doFullRect();
            this.cv.repaint();
        }
        if (object == this.squareButton) {
            this.doSquare();
            this.cv.repaint();
        }
        if (object == this.highPassButton) {
            this.doHighPass();
            this.cv.repaint();
        }
        if (object == this.noiseButton) {
            this.doNoise();
            this.cv.repaint();
        }
        if (object == this.phaseButton) {
            this.doPhaseShift();
            this.cv.repaint();
        }
        if (object == this.blankButton) {
            this.doBlank();
            this.cv.repaint();
        }
        if (object == this.sawtoothButton) {
            this.doSawtooth();
            this.cv.repaint();
        }
        if (object == this.clipButton) {
            this.doClip();
            this.cv.repaint();
        }
        if (object == this.quantizeButton) {
            this.doQuantize();
            this.cv.repaint();
        } else {
            this.quantizeCount = 0;
        }
        if (object == this.resampleButton) {
            this.doResample();
            this.cv.repaint();
        } else {
            this.resampleCount = 0;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.soundCheck && this.soundCheck.getState() && this.playThread == null) {
            this.playThread = new PlayThread();
            this.playThread.start();
        }
        if (itemEvent.getSource() == this.magPhaseCheck) {
            this.handleResize();
        }
        this.cv.repaint();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        System.out.print(((Scrollbar)adjustmentEvent.getSource()).getValue() + "\n");
        if (adjustmentEvent.getSource() == this.termBar) {
            this.updateSound();
            this.cv.repaint();
        }
        if (adjustmentEvent.getSource() == this.freqBar) {
            this.freqAdjusted = true;
            this.updateSound();
            this.cv.repaint();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.dragging = true;
        this.edit(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.dragX = n;
        this.dragY = n2;
        int n3 = this.selectedCoef;
        this.selectedCoef = -1;
        int n4 = this.selection = 0;
        if (this.viewFunc.contains(n, n2)) {
            this.selection = 1;
        } else {
            int n5 = this.getTermWidth();
            this.selectedCoef = n / n5;
            if (this.selectedCoef > this.termBar.getValue()) {
                this.selectedCoef = -1;
            }
            if (this.selectedCoef != -1) {
                if (this.viewMag.contains(n, n2)) {
                    this.selection = 2;
                } else if (this.viewMutes.contains(n, n2)) {
                    this.selection = 4;
                } else if (this.viewSolos.contains(n, n2)) {
                    this.selection = 5;
                } else if (this.viewPhase.contains(n, n2)) {
                    this.selection = 3;
                }
            }
        }
        if (this.selectedCoef != n3 || n4 != this.selection) {
            this.cv.repaint();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && this.selectedCoef != -1 && this.selection != 4 && this.selection != 5) {
            for (int i = 0; i != this.termBar.getValue(); ++i) {
                this.phasecoef[i] = 0.0;
                if (this.selectedCoef == i) continue;
                this.magcoef[i] = 0.0;
            }
            this.magcoef[this.selectedCoef] = 1.0;
            if (!this.magPhaseCheck.getState()) {
                this.phasecoef[this.selectedCoef] = this.selection == 2 ? -1.5707963267948966 : 0.0;
            }
            this.doSetFunc();
            this.cv.repaint();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
        if ((mouseEvent.getModifiers() & 4) != 0 && this.selectedCoef != -1) {
            this.termBar.setValue(this.selectedCoef + 1);
            this.cv.repaint();
        }
        if ((mouseEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        this.dragging = true;
        this.edit(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        this.dragging = false;
        if (this.selection == 1) {
            this.transform();
        } else if (this.selection != 0) {
            this.doSetFunc();
        }
        this.cv.repaint();
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            if (this.applet == null) {
                this.dispose();
            } else {
                this.applet.destroyFrame();
            }
            return true;
        }
        return super.handleEvent(event);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class PlayThread
    extends Thread {
        boolean changed;

        PlayThread() {
        }

        public void soundChanged() {
            this.changed = true;
        }

        public void run() {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Method method = null;
            try {
                object4 = Class.forName("javax.sound.sampled.AudioFormat");
                object3 = ((Class)object4).getConstructor(Float.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
                object2 = ((Constructor)object3).newInstance(new Float(22050.0f), new Integer(16), new Integer(1), new Boolean(true), new Boolean(true));
                Class<?> clazz = Class.forName("javax.sound.sampled.DataLine$Info");
                Class<?> clazz2 = Class.forName("javax.sound.sampled.SourceDataLine");
                object3 = clazz.getConstructor(new Class[]{class$java$lang$Class == null ? (class$java$lang$Class = FourierFrame.class$("java.lang.Class")) : class$java$lang$Class, object4});
                Object obj = ((Constructor)object3).newInstance(clazz2, object2);
                Class<?> clazz3 = Class.forName("javax.sound.sampled.AudioSystem");
                Class<?> clazz4 = Class.forName("javax.sound.sampled.Line$Info");
                Method method2 = clazz3.getMethod("getLine", clazz4);
                object = method2.invoke(null, obj);
                Method method3 = clazz2.getMethod("open", new Class[]{object4, Integer.TYPE});
                method3.invoke(object, object2, new Integer(4096));
                Method method4 = clazz2.getMethod("start", null);
                method4.invoke(object, null);
                byte[] byArray = new byte[1];
                method = clazz2.getMethod("write", byArray.getClass(), Integer.TYPE, Integer.TYPE);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                FourierFrame.this.playThread = null;
                return;
            }
            object4 = new FFT(16384);
            object3 = null;
            object2 = null;
            int n = 0;
            while (FourierFrame.this.soundCheck.getState()) {
                Fourier cfr_ignored_0 = FourierFrame.this.applet;
                if (Fourier.ogf == null) break;
                if (object3 == null || this.changed) {
                    int n2;
                    object3 = new double[32768];
                    int n3 = FourierFrame.this.termBar.getValue();
                    double d = Math.PI * 2 * FourierFrame.this.getFreq() / 22050.0;
                    Object object5 = 0.2;
                    this.changed = false;
                    for (n2 = 1; n2 != n3; ++n2) {
                        if (FourierFrame.this.hasSolo && !FourierFrame.this.solos[n2] || FourierFrame.this.mutes[n2]) continue;
                        int n4 = FourierFrame.this.dfreq0 * n2;
                        if (n4 >= 16384) break;
                        int n5 = (n2 & 1) == 1 ? -1 : 1;
                        object3[n4] = (double)n5 * FourierFrame.this.magcoef[n2] * Math.cos(FourierFrame.this.phasecoef[n2]);
                        object3[n4 + 1] = (double)(-n5) * FourierFrame.this.magcoef[n2] * Math.sin(FourierFrame.this.phasecoef[n2]);
                    }
                    ((FFT)object4).transform((double[])object3, true);
                    for (n2 = 0; n2 != 16384; ++n2) {
                        Object object6 = object3[n2 * 2];
                        if (object6 > object5) {
                            object5 = object6;
                        }
                        if (!(object6 < -object5)) continue;
                        object5 = -object6;
                    }
                    object2 = new byte[32768];
                    double d2 = 32767.0 / object5;
                    for (n2 = 0; n2 != 16384; ++n2) {
                        short s = (short)(object3[n2 * 2] * d2);
                        object2[n2 * 2] = (byte)(s / 256);
                        object2[n2 * 2 + 1] = (byte)(s & 0xFF);
                    }
                }
                try {
                    int n6 = 4096;
                    if (n >= ((?)object2).length) {
                        n = 0;
                    }
                    method.invoke(object, object2, new Integer(n), new Integer(n6));
                    n += n6;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    break;
                }
            }
            FourierFrame.this.playThread = null;
        }
    }

    class View
    extends Rectangle {
        int midy;
        int labely;
        double ymult;
        int periodWidth;

        View(int n, int n2, int n3, int n4) {
            super(n, n2, n3, n4);
            this.midy = n2 + n4 / 2;
            this.ymult = 0.6 * (double)n4 / 2.0;
            this.periodWidth = n3 / 3;
            this.labely = this.midy - 5 - n4 * 3 / 8;
        }
    }
}

